'
' Demo/Test code for Comb Sort vs CR2Sort
' for the TBS(8/2017)
'
' Please edit elements and/or randomdata
'
'
If MM.Device$="Micromite MkII" Then CPU 48
Option EXPLICIT
Option base 0
' const
Const elements   = 10 ' MM2: elements => 6 & <= 1000
Const randomdata = 1  ' randomdata = 0 uses the predefined Data
                      ' randomdata = 1 creates numerical random data
                      ' for randomdata = 0 must elements <=100
Const maxlen  = 20
Const verbose = 0
'
' vars
Dim integer t, i, h
Dim integer ts(2)=(0,0,0) 'time
Dim integer errorcounter = 0, tests = 0 'counter
Dim string SP$(elements) length maxlen, SPo$
Dim string SPB$(elements) length maxlen
' Main loop
Do While errorcounter=0
    tests=tests+1
    If randomdata Then
       CreateTestdata SP$(), elements, maxlen
    Else
       InitSP elements
    EndIf
    If verbose Then
    For i = 1 To elements
       Print i,SP$(i)
    Next i
    EndIf
    Timer=0
    oCombSort SP$(), elements
    t=Timer:ts(1)=ts(1)+t
    Print "COMBSORT=";t;"mS"
    Print
    SPo$=""
    For i = 1 To elements
    If verbose Then
       Print i,SP$(i)
    EndIf
       If SPo$ > SP$(i) Then
          Print "COMBSORT Error! at pos";i,SPo$,SP$(i):End
          errorcounter=errorcounter+1
          For h = 1 To elements
             Print h,"  ";SP$(h)
          Next
       EndIf
       SPo$=sp$(i)
    Next
'------------
    If randomdata Then
      RestoreTestdata elements
    Else
      InitSP elements
    EndIf
    If verbose Then
    For i = 1 To elements
       Print i,SP$(i)
    Next i
    EndIf
    Timer=0
    CR2SORT elements
    t=Timer:ts(2)=ts(2)+t
    Print "CR2SORT=";t;"mS"
    Print
    SPo$=""
    For i = 1 To elements
    If verbose Then
       Print i,SP$(i)
    EndIf
       If SPo$ > SP$(i) Then
          Print "CR2SORT Error! at pos";i:Print SPo$,SP$(i)
          errorcounter=errorcounter+1
          For h = 1 To elements
             Print h,"  ";SP$(h)
          Next
       EndIf
       SPo$=sp$(i)
    Next
    Print "---------------------------"
    Print "COMBSORT=";ts(1);"mS"
    Print "CR2SORT =";ts(2);"mS"
    Print "Errors   ";errorcounter
    Print "Tests    ";tests
    Print "==========================="
    Print
'    Pause 1000
  Loop
End
'-----------------------------------------------------------------
' Comb Sort
' an optimized (8/2017 by twofingers@TBS) version of aCombSort for strings.
' It sorts the array S$() and needs the number of elements to sort (STop)
' System: MM2/MMBasic 5.04.05
'
Sub oCombSort(S() As string ,STop As integer)
Local string M$
Local integer i, h, T=1, F=0, sw
Local float Gap=STop, Shrink=1.3
Do While Gap>1 Or Sw
  Gap=Int(Gap/Shrink)
  If Gap<1 Then Gap=1
  i=1:Sw=F
  For h=i+Gap To STop
    If S(i)>S(h) Then
       M$=S(i):S(i)=S(h):S(h)=M$:Sw=T
    EndIf
    i=i+1
  Next h
Loop
End Sub
'-----------------------------------------------------------------
' Cube Root of Two Sort
    Sub CR2SORT(SPtop)
        Local INTEGER i,x,b
        Local FLOAT p,y
        Local STRING a$
        p=1.2599211
        x=2: b=1: y=SPtop/2
        While y>2: y=y/p: Wend
        While x>1
            y=y*p
            x=SPtop\y
            For i=0 To SPtop-x
                If SP$(b+i)>SP$(x+i) Then a$=SP$(b+i):SP$(b+i)=SP$(x+i):SP$(x+i)=a$ 'SWAP SP$(b+i),SP$(x+i)
            Next
        Wend
    End Sub
'
Sub CreateTestData(s() As string, x, mlen)
Local i, j, TP$
  Print "Creating ";x;" random strings"
  For i = 1 To x
        If MM.Device$="Micromite MkII" Then
           Print i;Chr$(13);
        EndIf
        TP$=""
        S(i)=""
        For j = 1 To mlen
            TP$ = Chr$(Int(Rnd()*10+48))
            S(i)=S(i)+TP$
        Next j
        SPB$(i)=S(i)
    '    Print i, S(i)
  Next i
End Sub
'
Sub RestoreTestData(x)
Local i
    Print "Restoring";x;" random strings"
    For i = 1 To x
      If MM.Device$="Micromite MkII" Then
         Print i;Chr$(13);
      EndIf
      SP$(i)=SPB$(i)
    Next i
End Sub
'
' Initialise the data-set
Sub InitSP(x)
    Local integer n
    If x > 100 Then
      Print "Error: too much elements for InitSP()! max. 100!" x
      Exit Sub
    EndIf
    Restore
    For n=0 To x:Read SP$(n)
      If MM.Device$="Micromite MkII" Then
         Print i;Chr$(13);
      EndIf
    Next n
End Sub
'
'Data
'
Data "zak","sheila","fred","archie"
Data "jim","barry","alan","kevin"
Data "charles","steve","stephanie","jon"
Data "sonia","xavier","mark","adi"
Data "darren","paul","toby","jp"
Data "josie","kingsley","vod","oregon"
Data "lou anne","ian","syed","craig"
Data "james", "jules","judith","julie"
Data "fargo","david","hanson","dakota"
Data "picard", "riker", "morn", "quark"
Data "cisco", "morgan","bennett","white"
Data "black","brown","red","orange"
Data "green","blue","grey","violet"
Data "smith","kadiyam","shah","moore"
Data "saxton","murray","mitchell","alaie"
Data "aa","bb","cc","dd"
Data "ee","ff","gg","gg"
Data "[Bzz","hh","ii","jj"
Data "hgjhg","ufyf","serg","iuyyrre"
Data "hiuhiuh","fdresppokm","khgugftrdtrhtfyguguF","gfhf"
Data "pic","micro","microchip","atmel"
Data "intel","zilog","amd","nvidia"
Data "mitsubishi","nissan","volkswagen","bmw"
Data "tesla","audi","toyota","honda"
Data "suzuki","yamaha","yamaha","kawasaki"
Data "mike"
Data "20084106164251573640"
Data "10531883185171653201"
Data "90004818083998944261"
Data "46045602829899834073"
Data "90197464623706602236"
Data "54148726867249296682"
Data "55652874987423287803"
Data "65535197073569421169"
Data "27900568313837255831"
Data "47810513192160137131"
Data "12621687893234083536"
Data "74610546413405727826"
Data "13743322750345430976"
Data "58646196500252182670"
Data "20619039529609769860"
Data "33711828937712748083"
Data "46625238736490714095"
Data "19015037090698374675"
Data "46211338437111560093"
Data "52209137351389008050"
Data "90568598851816470784"
Data "71565875201310235452"
Data "76021328158253005775"
Data "44020231598211016353"
Data "10336929775264649962"
Data "16941596017315828088"
Data "28142753042492812971"
Data "53291109291904636906"
Data "04605646649678204517"
Data "91485976410605755044"
Data "15352866217815079244"
Data "14790252674816986457"
Data "01542078829543784467"
Data "84695838725124745846"
Data "42902387188108429924"
Data "30176781747263434450"
Data "09403997448947935184"
Data "13180666050010847198"
Data "87790408097674074634"
Data "00693907673555693669"
Data "86231858655674220311"
Data "25503775596400171875"
Data "86573489248914238550"
Data "91995087995674072012"
Data "64816566220893926772"
Data "48630518826521694088"
Data "16430739378985575110"
Data "75760973378192199937"
Data "24494166809665792007"
Data "02524327351068185130"
Data "20442963949746532883"
Data "94761785606054063949"
Data "68965031455668981796"
Data "17420260979755024046"
Data "59324152609171577238"
Data "07674656318601594903"
Data "25022663305677185025"
Data "42797872798599303707"
Data "87963569919114941889"
Data "61116568002714840330"
Data "02298127241459066605"
Data "25304661251813501715"
Data "64458643707312348812"
Data "55038010701778550905"
Data "61508605806842614828"
Data "20582990884532496310"
Data "61426631996058347034"
Data "93256496091587559970"
Data "89346952196328676363"
Data "36558911159416954897"
Data "02295963536825476789"
Data "32916191142474878245"
Data "67513204503247766667"
Data "88891360487492973203"
Data "89987307963093064982"
Data "29203498253828313147"
Data "07838210664389450718"
Data "72529438683409449504"
Data "56204568802815008322"
Data "10925344897328904410"
Data "20323106486938569362"
Data "36793900698024097783"
Data "80417409923801775397"
Data "62776114522375052118"
Data "92998918509609505084"
Data "20193701465419367706"
Data "99949589795423255936"
Data "48821964877305960291"
Data "81212891793906261254"
Data "11804968512475098569"
Data "04675597898103485374"
Data "56770963834206489809"
Data "86647191325033579977"
Data "15509688644305797387"
Data "20381010467877736175"
Data "91631784505949353844"
Data "69167773670331491133"
Data "76056843608575981200"
Data "75214802017407371146"
Data "40693825261374037885"
Data "34667675150579550548"
